﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja ZUS Z-3</title>
		<script runat="server">

            static bool zasadniczeGodzWKol6 = false;

            public class SrParams: SerializableContextBase {
                public SrParams(Context context)
                    : base(context) {
                }

                bool zasadniczeGodzWKol6 = false;
                [Priority(1)]
                [Caption("Jak zasad. godz. w k.6")]
                public bool ZasadniczeGodzWKol6 {
                    get { return zasadniczeGodzWKol6; }
                    set {
                        zasadniczeGodzWKol6 = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            [SettingsContext]
            public SrParams SrPars {
                set { zasadniczeGodzWKol6 = value.ZasadniczeGodzWKol6; }
            }

            public class PrnParams: Soneta.Business.ContextBase {

                public readonly INieobecnoscLubZbieg Nieobecność;

                public static Date LoadPoczątek(INieobecnosc Nieobecność) {
                    var zwolnienia = Periods.New(Nieobecność.Okres);
                    var maska = new FromTo(Date.MinValue, Nieobecność.Okres.From - 1);

                    foreach (ZbiegPracyIRodzicielstwa z in Nieobecność.Pracownik.ZbiegiPracyIRodzicielstwa)
                        zwolnienia += z.Okres * maska;

                    KalkulatorPracy kal = new KalkulatorPracy(Nieobecność.Pracownik);
                    foreach (INieobecnosc n in kal.Nieobecnosci(new FromTo(Date.MinValue, Nieobecność.Okres.From - 1), true))
                        if (n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS)
                            zwolnienia += n.Okres;

                    zwolnienia = zwolnienia.ToFlat();
                    var lst = new List<FromTo>(zwolnienia.Cast<FromTo>());
                    lst.Reverse();
                    FromTo prev = Nieobecność.Okres;
                    foreach (FromTo n in lst)
                        if (Kontynuacja(prev, n))
                            prev = n;
                        else
                            break;

                    return prev.From;
                }

                static bool Kontynuacja(FromTo current, FromTo prev) {
                    YearMonth cm = new YearMonth(current.From);
                    YearMonth pm = new YearMonth(prev.To);

                    int c = cm - pm;
                    c -= 1;

                    return c < 3;//Podstawę przeliczamy jeżeli pomiędzy końcem poprzedniej a początkiem 
                                 //nastepnej nieobecności ZUS muszą są co najmniej 3 pełne miesiące kalendarzoe
                }

                public FromTo OkresZatrudnienia() {
                    if (początek == Date.Empty)
                        return FromTo.Empty;
                    FromTo okres = Nieobecność.Pracownik[początek].Etat.OkresZatrudnienia;
                    if (okres.From.Day > 1 && DniPracyDo(Nieobecność.Pracownik, okres.From-1)>0)   //TID: 23589
                        okres *= new FromTo((new YearMonth(okres.From) + 1).FirstDay, Date.MaxValue);
                    return okres;
                }

                public FromTo OkresZatrudnieniaRok() {
                    return OkresZatrudnienia() * new FromTo(new Date(Nieobecność.Okres.From.Year, 1, 1), Date.MaxValue);
                }

                bool DlaPracownikaZwalnianego() {
                    FromTo on = Nieobecność.Okres;
                    FromTo oz = Nieobecność.Pracownik[on.From].Etat.OkresZatrudnienia;
                    return oz==FromTo.Empty || on.To>oz.To;
                }

                public PrnParams(Context context): base(context) {
                    Nieobecność = (INieobecnoscLubZbieg)context[typeof(INieobecnoscLubZbieg)];
                    Początek = LoadPoczątek(Nieobecność);
                    ubezpieczeni = new Date(Początek.Year-1, 11, 30);
                    dlaZwalnianego = zasPoDacieZwolnienia = DlaPracownikaZwalnianego();
                }

                Date początek;
                [Required]
                [Priority(10)]
                [Caption("Okres zasiłkowy od")]
                public Date Początek {
                    get { return początek; }
                    set {
                        początek = value;
                        int delta = początek<new Date(2005, 2, 8) ? 5 : 11;
                        YearMonth to = new YearMonth(początek)-1;
                        YearMonth from = to - delta;
                        okres = new FromTo(from.FirstDay, to.LastDay) * OkresZatrudnienia()
                            //TID: 23589
                            * new FromTo(Przesuń(Nieobecność.Pracownik, ZmianaWymiaru(Nieobecność.PracHistoria)), Date.MaxValue);
                        if (okres == FromTo.Empty)      //TID: 19896
                            okres = new YearMonth(początek) * Nieobecność.Pracownik[początek].Etat.OkresZatrudnienia;
                        OnChanged(EventArgs.Empty);
                    }
                }

                [Priority(11)]
                public Fraction Współczynnik {
                    get {
                        var start = Nieobecność.Pracownik[Początek];
                        var nieob = Nieobecność.Pracownik[Nieobecność.Okres.From];

                        var wymiarS = start.Etat.Wymiar;
                        var wymiarN = nieob.Etat.Wymiar;
                        if (Nieobecność is ZbiegPracyIRodzicielstwa)
                            wymiarN = WymiarUmowa(nieob) - wymiarN;

                        return wymiarN/wymiarS;
                    }
                }

                FromTo okres;
                [Required]
                [Priority(20)]
                [Caption("Okresy miesięczne")]
                public FromTo Okres {
                    get { return okres; }
                    set {
                        okres = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                FromTo okresowe;
                [Priority(30)]
                [Caption("Pozostałe okresy")]
                public FromTo Okresowe {
                    get {
                        if (okres == FromTo.Empty)
                            return FromTo.Empty;
                        YearMonth to = new YearMonth(okres.To);
                        YearMonth from = to - 11;
                        return new FromTo(from.FirstDay, to.LastDay) * OkresZatrudnienia();
                    }
                }

                Date ubezpieczeni;
                [Priority(40)]
                [Caption("Ubezpieczeni na dzień")]
                public Date Ubezpieczeni {
                    get { return ubezpieczeni; }
                    set {
                        ubezpieczeni = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                [Browsable(false)]
                public FromTo OkresZasiłkowy {
                    get { return new FromTo(początek, Nieobecność.Okres.To); }
                }

                bool dlaZwalnianego;
                bool zasPoDacieZwolnienia;
                [Priority(50)]
                [Caption("Zas.po dacie zwolnienia")]
                public bool ZasPoDacieZwolnienia {
                    get { return zasPoDacieZwolnienia; }
                    set {
                        zasPoDacieZwolnienia = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public bool IsReadOnlyZasPoDacieZwolnienia() {
                    return !dlaZwalnianego;
                }

                string rachBank;
                [Priority(60)]
                [Caption("Rachunek bankowy")]
                public string RachBank {
                    get { return rachBank; }
                    set {
                        rachBank = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public object GetListRachBank() {
                    List<string> list = new List<string>();

                    Soneta.Business.View v = Nieobecność.Pracownik.Rachunki.CreateView();
                    v.Sort = "Priorytet";
                    foreach (RachunekBankowyPracownika rbp in v)
                        if (!rbp.Blokada)
                            list.Add(rbp.Rachunek.Numer.ToString());

                    return list;
                }
            }
            /*
                static void Msg(params object[] pars) {
                    StringBuilder sb = new StringBuilder();
                    bool first = true;
                    foreach (object obj in pars) {
                        if (first)
                            first = false;
                        else
                            sb.AppendLine();
                        sb.Append(obj == null ? "(null)" : obj.ToString());
                    }
                }        
            */

            public static Fraction WymiarUmowa(PracHistoria ph) {
                Fraction w = ph.Etat.Wymiar;
                if (w == Fraction.Zero)
                    return Fraction.Zero;
                var z = (ZbiegPracyIRodzicielstwa)ph.Session.Get<KalendModule>().ZbiegiPracyIRodz.WgPracownik[ph.Pracownik].GetPrev(true, ph.Aktualnosc.From);
                if (z == null || z.Okres.To < ph.Aktualnosc.From)
                    return w;
                Debug.Assert(z.Okres.Contains(ph.Aktualnosc.From));
                return z.WymiarEtatu;
            }

            static bool zasPoDacieZwolnienia;
            static Set<string> nieWliczaneDoPodstawy = new Set<string>();

            static TypPodstawyZasilku GetZasilkiTyp(WypElement e) {
                //TID: 16006, W tabelce zawsze pomijać zasiłki ( obecnie jest błędnie pobierana kwota macierzyńskiego po dacie zwolnienia)
                if (e.ZasiłekZus)
                    return TypPodstawyZasilku.NieWliczać;

                TypPodstawyZasilku t = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ;
                if (!zasPoDacieZwolnienia || t != 0)
                    return t;
                //Nie stanowi podstawy zasiłku (to oczywiste)
                //Stanowi podstawę naliczania składek ZUS

                if (e.Definicja.Deklaracje.Spoleczne.Typ == TypUbezpieczeniaSpolecznego.NieNaliczać)
                    return TypPodstawyZasilku.NieWliczać;

                return TypPodstawyZasilku.WliczaćDla;
            }

            PrnParams pars;
            [Soneta.Business.Context(Required=true)]
            public PrnParams Params {
                set {
                    pars = value;
                    zasPoDacieZwolnienia = pars.ZasPoDacieZwolnienia;
                }
            }

            class Podstawa {

                readonly Fraction współczynnik;

                public Podstawa(Fraction współczynnik) {
                    this.współczynnik = współczynnik;
                }

                protected decimal Przelicz(decimal value) {
                    return  Soneta.Tools.Math.RoundCy(value * (decimal)współczynnik);
                }
            }

            class PodstawaSkładek : Podstawa {

                readonly protected Pracownik pracownik;
                readonly FromTo okres;
                Date dataSkładek = Date.MaxValue;
                TytulUbezpieczenia tyub = TytulUbezpieczenia.Empty;

                public PodstawaSkładek(Pracownik pracownik, FromTo okres, Fraction współczynnik): base(współczynnik) {
                    this.pracownik = pracownik;
                    this.okres = okres;
                }

                protected void AddElement(WypElement element, TypPodstawyZasilku t) {
                    if (t != 0) {
                        if (tyub == TytulUbezpieczenia.Empty && element.Podatki.TyUb != TytulUbezpieczenia.Empty)
                            tyub = element.Podatki.TyUb;
                        if (element.Data < dataSkładek)
                            dataSkładek = element.Data;
                    }
                }

                public Percent Procent {
                    get {
                        if (dataSkładek == Date.MaxValue || tyub == TytulUbezpieczenia.Empty)
                            return Percent.Zero;

                        decimal mnożnik = PodstawaZasiłku.PoliczMiesiąc.WyliczSkładkiZus(okres, dataSkładek, pracownik, tyub);
                        return new Percent(mnożnik);
                    }
                }
            }

            class SumMiesiąc : PodstawaSkładek, IComparable {
                readonly YearMonth ym;
                readonly Date dt;
                readonly int norma;
                readonly int praca;
                decimal zasadnicze;
                decimal proporcjonalne;
                decimal faktyczne;
                Hashtable nieobecnosci = new Hashtable();
                decimal wspDopełnienia = 1m;

                Set<WypSkladnik> uwzględnoneSkładniki = new Set<WypSkladnik>();
                decimal WartośćPomniejszenia(WypSkladnik skl, bool bezPomnZus) {
                    if (!(skl is WypSkladnikPomniejszenie) && !(skl is WypSkladnikStorno))
                        throw new ArgumentException("Oczekiwany składnik typu pomniejszenie zamiast " + skl.GetType() + ".");
                    if (uwzględnoneSkładniki.Contains(skl))
                        return 0;
                    uwzględnoneSkładniki.Add(skl);

                    //TID: 9873
                    Nieobecnosc n = skl.Nieobecnosc;
                    if (n != null && n.Definicja.Typ == TypNieobecnosci.Storno)
                        n = n.Zrodlo as Nieobecnosc;

                    //if (n != null && n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS)
                    if (n != null && n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS && bezPomnZus)     //TID: 11407
                        return 0;
                    return skl.Wartosc;
                }

                decimal WartośćElementu(WypElement e) {
                    decimal w = 0;
                    foreach (WypSkladnik s in e.Skladniki)
                        if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)
                            w += WartośćPomniejszenia(s, false);     //TID: 11407
                        else
                            w += s.Wartosc;
                    return w;
                }

                public SumMiesiąc(Pracownik pracownik, YearMonth ym, Fraction współczynnik, Date dt)
                    : base(pracownik, ym.ToFromTo(), współczynnik) {
                    this.ym = ym;
                    this.dt = dt;

                    FromTo okres = ym.ToFromTo();
                    FromTo oz = okres * pracownik[okres.To].Etat.OkresZatrudnienia;

                    //norma = pracownik.Czasy.Norma(oz).Dni
                    //    - pracownik.Czasy.KalkPracy.NormaNie(oz, Nieobecnosc.Nieusprawiedliwiona).Dni;
                    int n = pracownik.Czasy.Norma(oz).Dni;
                    norma = n; //- pracownik.Czasy.KalkPracy.NormaNie(oz, Nieobecnosc.Nieusprawiedliwiona).Dni;

                    //praca = pracownik.Czasy.Praca(oz, Dzien.Pracy, AlgorytmyPłacowe.OR, Dzien.Zestawienie).Dni
                    //    + pracownik.Czasy.KalkPracy.NormaNie(oz, Nieobecnosc.UsprawiedliwionaPłatna).Dni;
                    int p = pracownik.Czasy.Praca(oz, Dzien.Pracy, AlgorytmyPłacowe.OR, Dzien.Zestawienie).Dni;
                    int nie = pracownik.Czasy.KalkPracy.NormaNie(oz).Dni;
                    if (p > n - nie)
                        p = n - nie;
                    praca = p + pracownik.Czasy.KalkPracy.NormaNie(oz, Nieobecnosc.UsprawiedliwionaPłatna).Dni;

                    //TID: 19896
                    if (oz != okres) {
                        Time normaOz = pracownik.Czasy.Norma(oz).Czas;
                        Time normaMies = pracownik.Czasy.Norma(okres).Czas;
                        if (normaOz!=Time.Zero)
                            wspDopełnienia = (decimal)normaMies.TotalMinutes / normaOz.TotalMinutes;
                    }
                }
                public int CompareTo(object obj) {
                    if (obj == null)
                        return 1;
                    SumMiesiąc sm = obj as SumMiesiąc;
                    if (sm == null)
                        throw new ArgumentException();
                    return ym.CompareTo(sm.Miesiąc);
                }
                public void Add(WypElement e) {
                    bool godzinowa = e.PracHistoria.Etat.Zaszeregowanie.RodzajStawki == RodzajStawkiZaszeregowania.Godzinowa;
                    TypPodstawyZasilku t = GetZasilkiTyp(e);
                    if (e is WypElementUmowa && ((WypElementUmowa)e).UmowaHistoria.Okres.To < dt)
                        return;

                    AddElement(e, t);

                    switch (t) {
                        case TypPodstawyZasilku.WliczaćDla:
                            faktyczne += WartośćElementu(e);                //TID: 8873
                            break;
                        case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                        case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            LiczProporcjonalne(e, godzinowa);
                            break;
                        case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                            if (godzinowa && !zasadniczeGodzWKol6)
                                LiczProporcjonalne(e, godzinowa);
                            else
                                LiczZasadnicze(e, godzinowa);
                            break;
                        case TypPodstawyZasilku.WliczaćWNominalnejWysokościDla:
                            LiczZasadnicze(e, godzinowa);
                            break;
                    }

                    if (e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ == 0 && t == TypPodstawyZasilku.WliczaćDla && e.Wartosc!=0)
                        nieWliczaneDoPodstawy.Add(e.Definicja.Nazwa);
                }

                //TID: 5538
                bool UwzględniajPomniejszenie(WypElement e, bool godzinowa) {
                    TypPodstawyZasilku t = GetZasilkiTyp(e);

                    //TID: 8614
                    if (t == TypPodstawyZasilku.NieWliczać)
                        return false;

                    //TID: 8737
                    if (t == TypPodstawyZasilku.WliczaćDla)
                        return false;

                    if (godzinowa)
                        switch (t) {
                            case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                            case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                                return false;
                        }

                    return true;
                }

                void LiczProporcjonalne(WypElement e, bool godzinowa) {
                    //proporcjonalne += e.Wartosc;               
                    Nieobecnosc nieobecność = e is WypElementNieobecność || e is WypElementStorno ? (Nieobecnosc)e.BazaZrodla : null;
                    decimal wartośćNominalna = e.WartośćNominalna;
                    if (nieobecność == null) {
                        wartośćNominalna *= wspDopełnienia;                                 //TID: 19896
                        if (wspDopełnienia!=1m && e is WypElementEtat) {                    //TID: 19896.2
                            var stawka = ((Currency)AlgorytmyPłacowe.ZasadniczeNominalne(e.Pracownik, e.Okres.To)).Value;       //TID: 19896.2
                            if (System.Math.Abs(stawka - wartośćNominalna)<1m)
                                wartośćNominalna = stawka;
                        }
                        proporcjonalne += wartośćNominalna;
                        decimal f = 0;
                        decimal p = 0;
                        foreach (WypSkladnik s in e.Skladniki)
                            if (s is WypSkladnikOdchyłka)
                                if (s is WypSkladnikOdchyłka.AkordMinus && godzinowa)  //TID: 9837
                                    p += s.Wartosc;
                                else
                                    f += s.Wartosc;
                            else if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)
                                p += WartośćPomniejszenia(s, false);            //TID: 8873
                        faktyczne += f;
                        proporcjonalne += p;
                    }
                    else if (nieobecność.Definicja.Typ != TypNieobecnosci.UsprawiedliwionaPłatna)
                        proporcjonalne += wartośćNominalna;
                    else {
                        decimal p = wartośćNominalna;
                        //if (Podstawowy(e))  //TID: 8664 --> zamiast tego jest poprawka 8873
                        foreach (WypSkladnik s in nieobecność.Pomniejszenia)
                            if (e.Okres.Contains(s.Okres.To) && UwzględniajPomniejszenie(s.Element, godzinowa))
                                if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)      //TID: 9734
                                    p += WartośćPomniejszenia(s, true);            //TID: 8873
                        //TID: 
                        //faktyczne += k;
                        proporcjonalne += p;
                    }
                }

                void LiczZasadnicze(WypElement e, bool godzinowa) {
                    Nieobecnosc nieobecność = e is WypElementNieobecność || e is WypElementStorno ? (Nieobecnosc)e.BazaZrodla : null;
                    decimal wartośćNominalna = e.WartośćNominalna;
                    if (nieobecność == null) {
                        wartośćNominalna *= wspDopełnienia;                                 //TID: 19896
                        if (wspDopełnienia!=1m && e is WypElementEtat) {                    //TID: 19896.2
                            var stawka = ((Currency)AlgorytmyPłacowe.ZasadniczeNominalne(e.Pracownik, e.Okres.To)).Value;
                            if (System.Math.Abs(stawka - wartośćNominalna)<1m)
                                wartośćNominalna = stawka;
                        }
                        zasadnicze += wartośćNominalna;
                        decimal z = 0;
                        decimal f = 0;
                        decimal p = 0;
                        foreach (WypSkladnik s in e.Skladniki)
                            if (s is WypSkladnikOdchyłka)
                                if (s is WypSkladnikOdchyłka.AkordMinus && !godzinowa)  //TID: 8731
                                    zasadnicze += s.Wartosc;
                                //else if (s is WypSkladnikPomniejszenie)
                                //    f += WartośćPomniejszenia(s);            //TID: 8873
                                else
                                    f += s.Wartosc;
                            else if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno) {
                                decimal we = WartośćPomniejszenia(s, true);            //TID: 8873
                                if (s.Nieobecnosc != null && s.Nieobecnosc.Definicja.Rozliczenie == RozliczenieNieobecnosci.Brak) {
                                    if (s.Nieobecnosc.Definicja.Przyczyna == PrzyczynaNieobecnosci.NieusprawiedliwionaNiepłatna) {
                                        nieusprawiedliwiona = (we != 0);
                                        z += we;
                                    }
                                }
                                else
                                    p += we;
                            }
                        zasadnicze += z;
                        faktyczne += f;
                        proporcjonalne += p;
                    }
                    else if (nieobecność.Definicja.Typ != TypNieobecnosci.UsprawiedliwionaPłatna)
                        zasadnicze += wartośćNominalna;
                    else {
                        decimal p = wartośćNominalna;
                        //if (Podstawowy(e))  //TID: 8664 --> zamiast tego jest poprawka 8873
                        foreach (WypSkladnik s in nieobecność.Pomniejszenia)
                            if (e.Okres.Contains(s.Okres.To) && UwzględniajPomniejszenie(s.Element, godzinowa))
                                if (s is WypSkladnikPomniejszenie || s is WypSkladnikStorno)      //TID: 9734
                                    p += WartośćPomniejszenia(s, true);            //TID: 8873
                        //TID: 
                        //faktyczne += k;
                        proporcjonalne += p;
                    }
                }

                /*bool Podstawowy(WypElement e) {
                    List<WypSkladnik> lst = new List<WypSkladnik>(e.SkładnikiPowiązane);
                    lst.Sort();
                    bool first = true;
                    foreach (WypSkladnik skl in lst) {
                        if (skl.Element == e)
                            return first;
                        first = false;
                    }
                    return true;
                }*/

                public YearMonth Miesiąc {
                    get { return ym; }
                }
                public int Norma {
                    get { return norma; }
                }
                public int Praca {
                    get { return praca; }
                }
                public string Przyczyna {
                    get { return PrzyczynyNieobecności(pracownik, ym.ToFromTo()); }
                }
                public decimal Zasadnicze {
                    get { return Przelicz(zasadnicze); }
                }
                public decimal Proporcjonalne {
                    get { return Przelicz(proporcjonalne); }
                }
                public decimal Faktyczne {
                    get {
                        if (nieobecnosci != null) {
                            foreach (decimal d in nieobecnosci.Values)
                                if (d > 0m)
                                    faktyczne += d;
                            nieobecnosci = null;
                        }
                        return Przelicz(faktyczne);
                    }
                }
            }

            class SumOkresowy: Podstawa {
                readonly int norma;
                readonly int praca;
                readonly string przyczyna;
                decimal brutto;
                decimal zus;

                protected SumOkresowy(WypElement e, Fraction współczynnik): base(współczynnik) {
                    //TID: 5878               
                    /*bool bb = false;
                    switch (e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ) {
                        case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                        case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            bb = true;
                            break;
                        case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                            bb = e.Pracownik[e.Okres.To].Etat.Zaszeregowanie.RodzajStawki == RodzajStawkiZaszeregowania.Miesieczna;
                            break;
                    }*/
                    bool bb = e.Definicja.Nieobecnosci.ZasilkiPracownicy.Typ != TypPodstawyZasilku.NieWliczać;
                    if (bb) {
                        brutto += e.Wartosc;
                        zus += e.Podatki.KosztyZUS;

                        KalkulatorPracownika kalk = new KalkulatorPracownika(e.Pracownik);
                        FromTo okres = e.Okres;
                        norma = kalk.Norma(okres).Dni;

                        FromTo oz = okres * e.Pracownik[okres.To].Etat.OkresZatrudnienia;
                        praca = kalk.Praca(oz).Dni + kalk.KalkPracy.NormaNie(oz, Nieobecnosc.UsprawiedliwionaPłatna).Dni;

                        przyczyna = PrzyczynyNieobecności(e.Pracownik, e.Okres);
                    }
                }
                public decimal Kwota {
                    get { return Przelicz(brutto); }
                }
                public int Norma {
                    get { return norma; }
                }
                public int Praca {
                    get { return praca; }
                }
                public Percent Procent {
                    get { return brutto==0m ? Percent.Zero : new Percent(zus/brutto); }
                }
                public string Przyczyna {
                    get { return przyczyna; }
                }
            }

            class SumKwartał: SumOkresowy, IComparable {
                readonly YearMonth ym;
                public SumKwartał(WypElement e, Fraction współczynnik): base(e, współczynnik) {
                    ym = new YearMonth(e.Okres.To.Year, (e.Okres.To.Month-1)/3 + 1);
                }
                public int CompareTo(object obj) {
                    if (obj==null)
                        return 1;
                    SumKwartał sk = obj as SumKwartał;
                    if (sk==null)
                        throw new ArgumentException();
                    return ym.CompareTo(sk.ym);
                }
                public int Rok {
                    get { return ym.Year; }
                }
                public int Kwartał {
                    get { return ym.Month; }
                }
            }

            class SumRok: SumOkresowy, IComparable {
                readonly int rok;
                public SumRok(WypElement e, Fraction współczynnik): base(e, współczynnik) {
                    rok = e.Okres.To.Year;
                }
                public int CompareTo(object obj) {
                    if (obj==null)
                        return 1;
                    SumRok sr = obj as SumRok;
                    if (sr==null)
                        throw new ArgumentException();
                    return rok.CompareTo(sr.Rok);
                }
                public int Rok {
                    get { return rok; }
                }
            }

            class SumInne: SumOkresowy, IComparable {
                readonly FromTo okres;
                public SumInne(WypElement e, Fraction współczynnik): base(e, współczynnik) {
                    okres = e.Okres;
                }
                public int CompareTo(object obj) {
                    if (obj==null)
                        return 1;
                    SumInne si = obj as SumInne;
                    if (si==null)
                        throw new ArgumentException();
                    return okres.CompareTo(si.Okres);
                }
                public FromTo Okres {
                    get { return okres; }
                }
            }

            static int RodzajOkresu(FromTo okres) {
                YearMonth from = new YearMonth(okres.From);
                YearMonth to = new YearMonth(okres.To);
                return to - from + 1;
            }

            IEnumerable LiczMiesiące(PracHistoria ph, IEnumerable elementy, Fraction współczynnik) {
                Pracownik pracownik = ph.Pracownik;
                Hashtable ht = new Hashtable();
                //Date data = ZmianaWymiaru(ph);
                //Date data = Przesuń(pars.Nieobecność.Pracownik, ZmianaWymiaru(ph));  //TID: 23589
                //if (data < pars.Okres.From)
                //TID: 23589, jeżeli tylko jeden miesiąc wchodzi do podstawy to nigdy go nie pomijamy
                //if (data < pars.Okres.From || pars.Okres.From.ToYearMonth().ToFromTo().Contains(pars.Okres))
                //    data = Date.Empty;

                foreach (WypElement e in elementy) {
                    //if (data != Date.Empty)
                    //if (e.Okres.ToYearMonth() < data.ToYearMonth() || 
                    //    (e.Okres.ToYearMonth() == data.ToYearMonth() && e.Okres.From.Day != 1))
                    //if (e.Okres.ToYearMonth() <= data.ToYearMonth())
                    //        continue;
                    YearMonth ym = new YearMonth(e.Okres.To);
                    SumMiesiąc m = (SumMiesiąc)ht[ym];
                    if (m==null) {
                        m = new SumMiesiąc(pracownik, ym, współczynnik, pars.Nieobecność.Okres.From);
                        ht.Add(ym, m);
                    }
                    m.Add(e);
                }
                ArrayList al = new ArrayList(ht.Values);
                al.Sort();
                return al;
            }

            string NBSP(string ss) {
                return ss=="" ? "&nbsp;" : ss;
            }

            void LiczDaneFirmy(PracHistoria ph) {
                CoreModule core = CoreModule.GetInstance(dc);
                string nip = core.Config.Firma.Pieczątka.NIP;
                string regon = core.Config.Firma.Pieczątka.REGON;
                string nazwask = core.Config.Firma.Pieczątka.NazwaSkrócona;
                string nazwisko = core.Config.Firma.DaneEwidencyjne.Nazwisko;
                string imie = core.Config.Firma.DaneEwidencyjne.Imię;
                string kodp = core.Config.Firma.AdresSiedziby.KodPocztowyS;
                string poczta = core.Config.Firma.AdresSiedziby.Poczta;
                string gmina = core.Config.Firma.AdresSiedziby.Gmina;
                string miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
                string ulica = core.Config.Firma.AdresSiedziby.Ulica;
                string dom = core.Config.Firma.AdresSiedziby.NrDomu;
                string lokal = core.Config.Firma.AdresSiedziby.NrLokalu;
                string tel = core.Config.Firma.AdresSiedziby.Telefon;
                string symbol = core.Config.Firma.AdresSiedziby.KodKraju;
                string kodz = core.Config.Firma.AdresSiedziby.ZagranicznyKodPocztowy;
                string panstwo = core.Config.Firma.AdresSiedziby.Kraj;
                if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                    OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                    if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
                    if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
                    if (!string.IsNullOrEmpty(of.NazwaSkrocona)) nazwask = of.NazwaSkrocona;
                    if (!string.IsNullOrEmpty(of.Adres.KodPocztowyS)) kodp = of.Adres.KodPocztowyS;
                    if (!string.IsNullOrEmpty(of.Adres.Poczta)) poczta = of.Adres.Poczta;
                    if (!string.IsNullOrEmpty(of.Adres.Gmina)) gmina = of.Adres.Gmina;
                    if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
                    if (!string.IsNullOrEmpty(of.Adres.Ulica)) ulica = of.Adres.Ulica;
                    if (!string.IsNullOrEmpty(of.Adres.NrDomu)) dom = of.Adres.NrDomu;
                    if (!string.IsNullOrEmpty(of.Adres.NrLokalu)) lokal = of.Adres.NrLokalu;
                    if (!string.IsNullOrEmpty(of.Adres.Telefon)) tel = of.Adres.Telefon;
                    if (!string.IsNullOrEmpty(of.Adres.KodKraju)) symbol = of.Adres.KodKraju;
                    if (!string.IsNullOrEmpty(of.Adres.ZagranicznyKodPocztowy)) kodz = of.Adres.ZagranicznyKodPocztowy;
                    if (!string.IsNullOrEmpty(of.Adres.Kraj)) panstwo = of.Adres.Kraj;
                }

                FirmaNIP.EditValue = NBSP(nip.Replace("-", ""));
                FirmaREGON.EditValue = NBSP("");
                FirmaPESEL.EditValue = NBSP("");
                FirmaRodzaj.EditValue = NBSP("");
                FirmaDokument.EditValue = NBSP("");
                if (!string.IsNullOrEmpty(nazwask))
                    FirmaNazwa.EditValue = NBSP(nazwask.ToUpper());
                else
                    FirmaNazwa.EditValue = NBSP(imie.ToUpper()) + NBSP(nazwisko.ToUpper());
                FirmaKodP.EditValue = NBSP(kodp);
                ///        POCZTA.EditValue = NBSP(poczta);
                ///        GMINA.EditValue = NBSP(gmina);
                FirmaMiejscowosc.EditValue = NBSP(miejscowosc.ToUpper());
                FirmaUlica.EditValue = NBSP(ulica.ToUpper());
                FirmaNrDomu.EditValue = NBSP(dom);
                FirmaNrLokalu.EditValue = NBSP(lokal);
                ///        TEL.EditValue = NBSP(tel);
                ///        SYMBOL.EditValue = NBSP(symbol);
                ///        KODZ.EditValue = NBSP(kodz);
                FirmaKraj.EditValue = NBSP(panstwo.ToUpper());
                ///        MAIL.EditValue = NBSP("");

                if (regon!="")
                    FirmaREGON.EditValue = NBSP(regon);
                if (nip=="" || regon=="")
                    if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
                        string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
                        if (pesel=="") {
                            Wlasciciel wls = DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.DaneWłaściciela;
                            if (wls!=null) {
                                pesel = NBSP(wls.Last.PESEL);
                                if (pesel=="") {
                                    FirmaRodzaj.EditValue = NBSP(""); //wls.Last.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
                                    FirmaDokument.EditValue = NBSP(wls.Last.Dokument.SeriaNumer.ToUpper());
                                }
                            }
                        }
                        if (pesel!="")
                            FirmaPESEL.EditValue = NBSP(pesel);
                    }
            }

            static Date ZmianaWymiaru(PracHistoria ph) {
                FromTo okres = ph.Etat.OkresZatrudnienia;
                if (ph.Aktualnosc.From > okres.From)
                    while (true) {
                        PracHistoria prev = (PracHistoria)ph.Pracownik.Historia.GetPrev(ph);
                        if (prev == null || prev.Etat.OkresZatrudnienia != okres)
                            break;
                        if (WymiarUmowa(ph) != WymiarUmowa(prev))
                            return ph.Aktualnosc.From;
                        ph = prev;
                    }
                return Date.Empty;
            }

            //TID: 23589
            static Date Przesuń(Pracownik pracownik, Date data) {
                if (data.Day == 1 || DniPracyDo(pracownik, data - 1) == 0)
                    return data;
                return data.ToYearMonth().LastDay + 1;
            }

            static int DniPracyDo(Pracownik pracownik, Date data) {
                var kp = new KalkulatorPlanu(pracownik);
                var okres = new FromTo(data.ToYearMonth().FirstDay, data);
                return kp.Norma(okres).Dni;
            }

            FromTo PoprzedniWymiar(PracHistoria ph, ref Fraction wymiar) {
                if (ph.Aktualnosc.From > ph.Etat.OkresZatrudnienia.From) {
                    PracHistoria prev = (PracHistoria)ph.Pracownik.Historia.GetPrev(ph);
                    if (WymiarUmowa(ph) != WymiarUmowa(prev)) {
                        wymiar = WymiarUmowa(prev);
                        Date to = prev.Aktualnosc.To;
                        while (true) {
                            PracHistoria php = (PracHistoria)prev.Pracownik.Historia.GetPrev(prev);
                            if (php == null || WymiarUmowa(php) != wymiar)
                                break;
                            prev = php;
                        }
                        Date from = prev.Aktualnosc.From != Date.MinValue ? prev.Aktualnosc.From : prev.Etat.Okres.From;
                        return new FromTo(from, to);
                    }
                }
                return FromTo.Empty;
            }

            void LiczDanePracownika(PracHistoria ph) {
                PracImie.EditValue = ph.Imie.ToUpper();
                PracNazwisko.EditValue = ph.Nazwisko.ToUpper();

                bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
                if (ph.NIP == "" || ph.PESEL == "") {
                    //DOKRODZAJ.EditValue = dowod ? "1" : "2";
                    DOKUBEZP.EditValue = ph.Dokument.SeriaNumer.ToUpper();
                }
                else {
                    //DOKRODZAJ.EditValue = NBSP("");
                    DOKUBEZP.EditValue = NBSP("");
                }
                Date ur = ph.Urodzony.Data;
                ///        if (ur != Date.Empty) URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
                bool tymcz = (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowy || ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą);
                ZatrTymczTak.EditValue = tymcz ? "X" : "&nbsp;";
                ZatrTymczNie.EditValue = !tymcz ? "X" : "&nbsp;";

                bool zagr = (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikTymczasowyZaGranicą || ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.PracownikZaGranicą);
                ZatrZagrTak.EditValue = zagr ? "X" : "&nbsp;";
                ZatrZagrNie.EditValue = !zagr ? "X" : "&nbsp;";

                Date data = ZmianaWymiaru(ph);
                WymiarFrom.EditValue = data != Date.Empty ? data : ph.Etat.OkresZatrudnienia.From;
                IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
                AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
                ///        AdresPoczta.EditValue = adres.Poczta;
                ///        AdresGmina.EditValue = adres.Gmina;
                AdresMiejscowosc.EditValue = adres.Miejscowosc.ToUpper();
                AdresUlica.EditValue = adres.Ulica.ToUpper();
                AdresNrDomu.EditValue = adres.NrDomu;
                AdresNrLokalu.EditValue = adres.NrLokalu;
                ///        AdresKodKraju.EditValue = adres.KodKraju;
                ///        AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
                AdresKraj.EditValue = adres.Kraj.ToUpper();
            }

            Periods OkresyZatrudnienia(Pracownik pracownik, Date odDnia) {
                Periods okresy = Periods.Empty;
                foreach (HistoriaZatrudnieniaBase hz in pracownik.HistoriaZatrudnienia)
                    if (hz.Typ == TypHistoriiZatrudnienia.Zatrudnienie)
                        okresy += hz.Okres;

                foreach (PracHistoria ph in pracownik.Historia)
                    okresy += ph.Etat.Okres;

                okresy -= new FromTo(odDnia, Date.MaxValue);
                okresy = okresy.ToFlat();

                return okresy;
            }

            bool Wypadek(INieobecnosc nieobecnosc) {
                return nieobecnosc is Nieobecnosc && nieobecnosc.Zwolnienie.Przyczyna==PrzyczynaZwolnienia.WypadekPrzyPracyLubChorobaZawodowa;
            }

            static readonly string Empty = "</strong>. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<strong>";
            void LiczOkresyUbezpieczenia(INieobecnosc nieobecnosc, PracHistoria ph) {
                Date zatrOd = ph.Etat.OkresZatrudnienia.From;
                Periods okresy = OkresyZatrudnienia(ph.Pracownik, zatrOd);
                StazPracy poprzedni = StazPracy.Empty;
                foreach (FromTo o in okresy)
                    poprzedni += new StazPracy(o, ph).Normalizuj();
                poprzedni = poprzedni.Normalizuj();
                StazPracy staż = new StazPracy(new FromTo(zatrOd, pars.Początek), ph).Normalizuj();
                //Jeżeli okres zatrudnienia<30 dni i staż poprzedni<10lat i nie wypadek lub choroba 
                ///		if (staż.Lata>0 || staż.Miesiace>0 || staż.Dni>=30 || poprzedni.Lata>=10 || Wypadek(nieobecnosc))
                ///			POPRZEDNIE_OKRESY.EditValue = Empty;
                ///		else if (okresy==Periods.Empty)
                ///			POPRZEDNIE_OKRESY.EditValue = Empty;
                ///		else
                ///			POPRZEDNIE_OKRESY.EditValue = okresy;

                //Jeżeli okres zatrudnienia<2 lata
                ///		if (staż.Lata>=2)
                ///			AKTUALNE_OKRESY.EditValue = Empty;
                ///		else if (okresy==Periods.Empty)
                ///			AKTUALNE_OKRESY.EditValue = Empty;
                ///		else
                ///			AKTUALNE_OKRESY.EditValue = okresy;
            }

            string KodLiterowy(WypElement e, bool procent) {
                WypElementNieobecność en = e as WypElementNieobecność;
                string kod = "";
                if (en != null && en.Nieobecność != null) {
                    if (en.Nieobecność.Zwolnienie.KodChoroby != "")
                        kod = en.Nieobecność.Zwolnienie.KodChoroby;
                    if (procent && e.SkładnikGłówny != null &&
                        (en.Nieobecność.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopMacierzyński || en.Nieobecność.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopRodzicielski))
                        kod += (kod != "" ? "/" : "") + e.SkładnikGłówny.Procent;
                }
                return kod;
            }

            string GetElementyInfo(ICollection<WypElement> elementy, bool procent) {
                if (elementy.Count == 0)
                    return "";

                Dictionary<FromTo, string> okresy = new Dictionary<FromTo, string>();
                Dictionary<FromTo, int> hash = new Dictionary<FromTo, int>();
                int storno, ilosc;
                string kod;

                foreach (WypElement e in elementy) {
                    storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                    if (hash.TryGetValue(e.Okres, out ilosc))
                        hash[e.Okres] = ilosc + storno;
                    else
                        hash.Add(e.Okres, storno);
                    if (!okresy.TryGetValue(e.Okres, out kod))
                        okresy.Add(e.Okres, KodLiterowy(e, procent));
                    else if (kod == "")
                        okresy[e.Okres] = KodLiterowy(e, procent);
                }

                string result = "";
                foreach (FromTo ft in okresy.Keys) {
                    if (hash[ft] <= 0)
                        continue;
                    kod = okresy[ft];
                    if (kod == "")
                        kod = ".....";
                    string line = string.Format("{0} - {1} {2}", ft.From, ft.To, kod);
                    result += (result != "" ? "<br/>" : "") + line;
                }

                return result;
            }

            string LiczWynagrodzeniaZasiłki(Pracownik pracownik) {
                List<WypElement> wynagrodzania = new List<WypElement>();
                List<WypElement> zasiłki = new List<WypElement>();
                List<WypElement> macieżyńskie = new List<WypElement>();

                bool macieżyński = false, chorobowy = false, rehabilitacyjny = false;

                Dictionary<FromTo, string> okresy = new Dictionary<FromTo, string>();
                Dictionary<FromTo, string> okresy2 = new Dictionary<FromTo, string>();
                Dictionary<FromTo, int> hash = new Dictionary<FromTo, int>();
                Dictionary<FromTo, int> hash2 = new Dictionary<FromTo, int>();
                int storno, ilosc;
                string def;

                INieobecnoscLubZbieg pni = null;
                SubTable st = PlaceModule.GetInstance(dc).WypElementy.WgPracownik[pracownik];
                st = new SubTable(st, pars.OkresZatrudnieniaRok());
                foreach (WypElement e in st) {
                    try {
                        if (e is WypElementStorno || e.Dni < 0) {
                            if (hash.TryGetValue(e.Okres, out ilosc))
                                hash[e.Okres] = ilosc - 1;
                            else
                                hash.Add(e.Okres, -1);
                            if (hash2.TryGetValue(e.Okres, out ilosc))
                                hash2[e.Okres] = ilosc - 1;
                            else
                                hash2.Add(e.Okres, -1);
                        }
                        KodRSA kod = e.KodRSA;
                        if (kod != null && kod.WynagrodzenieChorobowe)
                            wynagrodzania.Add(e);
                        else if (e.ZasiłekZus /*&& e.Wartosc != 0*/ && pars.OkresZasiłkowy.IsIntersected(e.Okres)) {
                            if (e.Wartosc != 0) zasiłki.Add(e);
                            WypElementNieobecność en = e as WypElementNieobecność;
                            Nieobecnosc ni = en == null ? null : en.Nieobecność;
                            if (ni != null)
                                switch (ni.Definicja.Przyczyna) {
                                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                                        zasiłki.Remove(e); break;
                                    case PrzyczynaNieobecnosci.UrlopRodzicielski:
                                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                                    case PrzyczynaNieobecnosci.UrlopOjcowski:
                                        if (ni.Definicja.Guid == new Guid("00000000-0006-0005-0040-000000000000")) {
                                            storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                                            if (hash2.TryGetValue(e.Okres, out ilosc))
                                                hash2[e.Okres] = ilosc + storno;
                                            else
                                                hash2.Add(e.Okres, storno);
                                        }
                                        storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                                        if (hash.TryGetValue(e.Okres, out ilosc))
                                            hash[e.Okres] = ilosc + storno;
                                        else
                                            hash.Add(e.Okres, storno);
                                        if (ni.Definicja.Guid == new Guid("00000000-0006-0005-0040-000000000000") ||
                                            ni.Definicja.Guid == new Guid("00000000-0006-0005-0044-000000000000") ||
                                            ni.Definicja.Guid == new Guid("00000000-0006-0005-0045-000000000000")) {
                                            if (!okresy2.TryGetValue(e.Okres, out def))
                                                okresy2.Add(e.Okres, ni.Definicja.Nazwa);
                                            else
                                                okresy2[e.Okres] = ni.Definicja.Nazwa;
                                        }
                                        else {
                                            if (!okresy.TryGetValue(e.Okres, out def))
                                                okresy.Add(e.Okres, ni.Definicja.Nazwa);
                                            else
                                                okresy[e.Okres] = ni.Definicja.Nazwa;
                                            macieżyńskie.Add(e);
                                            zasiłki.Remove(e);
                                            macieżyński = true;
                                        }
                                        if (pni == null) pni = ni;
                                        break;
                                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                                        chorobowy = true; break;
                                    case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                                        rehabilitacyjny = true; break;
                                }
                        }
                    }
                    catch { Msg(); }
                }

                foreach (OkresNieobecności ni in pracownik.Czasy.Nieobecnosci(pars.OkresZatrudnieniaRok(), false)) {
                    bool result = true;
                    foreach (FromTo ft in hash.Keys)
                        if (ft.IsIntersected(ni.Okres)) {
                            result = false;
                            break;
                        }
                    if (result && pars.OkresZasiłkowy.IsIntersected(ni.Okres)) {
                        switch (ni.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopRodzicielski:
                            case PrzyczynaNieobecnosci.UrlopMacierzyński:
                            case PrzyczynaNieobecnosci.UrlopOjcowski:
                                if (hash.TryGetValue(ni.Okres, out ilosc))
                                    hash[ni.Okres] = ilosc + 1;
                                else
                                    hash.Add(ni.Okres, 1);
                                if (ni.Definicja.Guid != new Guid("00000000-0006-0005-0040-000000000000") &&
                                    ni.Definicja.Guid != new Guid("00000000-0006-0005-0044-000000000000") &&
                                    ni.Definicja.Guid != new Guid("00000000-0006-0005-0045-000000000000")) {
                                    if (!okresy.TryGetValue(ni.Okres, out def))
                                        okresy.Add(ni.Okres, ni.Definicja.Nazwa);
                                    else
                                        okresy[ni.Okres] = ni.Definicja.Nazwa;
                                    macieżyński = true;
                                }
                                if (pni == null) pni = (INieobecnoscLubZbieg)((Nieobecnosc)ni);
                                break;
                        }
                    }
                }

                Date start = zasiłki.Count == 0 ? Date.MaxValue : zasiłki[0].Okres.From;
                if (wynagrodzania.Count > 0 && wynagrodzania[0].Okres.From < start)
                    start = wynagrodzania[0].Okres.From;
                if (start == Date.MaxValue && pni != null) {
                    FromTo ft = pni.Okres * pars.OkresZatrudnieniaRok();
                    start = (ft != FromTo.Empty) ? ft.From : Date.MaxValue;
                }

                //TID: 10790
                //Cofamy się po 61 dni w poszukiwaniu zasiłków/wynagrodzeń
                //Jak znajdziemy jakiekolwiek, to cofamy się dalej, a wynagrodzenia dodajemy do listy                
                while (true) {
                    FromTo okres = new FromTo(start - 61, start - 1);

                    st = PlaceModule.GetInstance(dc).WypElementy.WgPracownik[pracownik];
                    st = new SubTable(st, okres);
                    bool any = false;

                    if (pni == null) pni = pars.Nieobecność;
                    ArrayList al = new ArrayList(st.ToArray<WypElement>());
                    al.Reverse();
                    foreach (WypElement e in al) {
                        try {
                            WypElementNieobecność en = e as WypElementNieobecność;
                            Nieobecnosc ni = en == null ? null : en.Nieobecność;
                            if (ni == null)
                                continue;
                            if (pni.Zwolnienie.KodChoroby != "A" && pni.Okres.From > ni.Okres.To + 1)
                                break;
                            pni = ni;
                            if (e is WypElementStorno || e.Dni < 0) {
                                if (hash.TryGetValue(e.Okres, out ilosc))
                                    hash[e.Okres] = ilosc - 1;
                                else
                                    hash.Add(e.Okres, -1);
                                if (hash2.TryGetValue(e.Okres, out ilosc))
                                    hash2[e.Okres] = ilosc - 1;
                                else
                                    hash2.Add(e.Okres, -1);
                            }
                            KodRSA kod = e.KodRSA;
                            bool ok = false;
                            if (kod != null && kod.WynagrodzenieChorobowe) {
                                wynagrodzania.Add(e);
                                ok = true;
                            }
                            else if (e.ZasiłekZus /*&& e.Wartosc != 0*/ && pars.OkresZasiłkowy.IsIntersected(e.Okres)) {
                                if (e.Wartosc != 0) zasiłki.Add(e);
                                if (ni != null)
                                    switch (ni.Definicja.Przyczyna) {
                                        case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                                            zasiłki.Remove(e); break;
                                        case PrzyczynaNieobecnosci.UrlopRodzicielski:
                                        case PrzyczynaNieobecnosci.UrlopMacierzyński:
                                        case PrzyczynaNieobecnosci.UrlopOjcowski:
                                            if (ni.Definicja.Guid == new Guid("00000000-0006-0005-0040-000000000000")) {
                                                storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                                                if (hash2.TryGetValue(e.Okres, out ilosc))
                                                    hash2[e.Okres] = ilosc + storno;
                                                else
                                                    hash2.Add(e.Okres, storno);
                                            }
                                            storno = (e is WypElementStorno || e.Dni < 0) ? -1 : 1;
                                            if (hash.TryGetValue(e.Okres, out ilosc))
                                                hash[e.Okres] = ilosc + storno;
                                            else
                                                hash.Add(e.Okres, storno);
                                            if (ni.Definicja.Guid == new Guid("00000000-0006-0005-0040-000000000000") ||
                                                ni.Definicja.Guid == new Guid("00000000-0006-0005-0044-000000000000") ||
                                                ni.Definicja.Guid == new Guid("00000000-0006-0005-0045-000000000000")) {
                                                if (!okresy2.TryGetValue(e.Okres, out def))
                                                    okresy2.Add(e.Okres, ni.Definicja.Nazwa);
                                                else
                                                    okresy2[e.Okres] = ni.Definicja.Nazwa;
                                            }
                                            else {
                                                if (!okresy.TryGetValue(e.Okres, out def))
                                                    okresy.Add(e.Okres, ni.Definicja.Nazwa);
                                                else
                                                    okresy[e.Okres] = ni.Definicja.Nazwa;
                                                macieżyńskie.Add(e);
                                                zasiłki.Remove(e);
                                                macieżyński = true;
                                            }
                                            break;
                                        case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                                            chorobowy = true; break;
                                        case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                                            rehabilitacyjny = true; break;
                                    }
                            }

                            if (!any && ok) {
                                any = true;
                                start = e.Okres.From;
                            }
                        }
                        catch { Msg(); }
                    }
                    if (!any)
                        break;
                }

                ArrayList all = new ArrayList((ICollection)pracownik.Czasy.Nieobecnosci(new FromTo(start-61, start-1), false));
                all.Reverse();
                foreach (OkresNieobecności ni in all) {
                    if (pni.Zwolnienie.KodChoroby != "A" && pni.Okres.From > ni.Okres.To + 1)
                        break;
                    pni = (INieobecnoscLubZbieg)((Nieobecnosc)ni);
                    bool result = true;
                    foreach (FromTo ft in hash.Keys)
                        if (ft.IsIntersected(ni.Okres)) {
                            result = false;
                            break;
                        }
                    if (result && pars.OkresZasiłkowy.IsIntersected(ni.Okres)) {
                        switch (ni.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopRodzicielski:
                            case PrzyczynaNieobecnosci.UrlopMacierzyński:
                            case PrzyczynaNieobecnosci.UrlopOjcowski:
                                if (hash.TryGetValue(ni.Okres, out ilosc))
                                    hash[ni.Okres] = ilosc + 1;
                                else
                                    hash.Add(ni.Okres, 1);
                                if (ni.Definicja.Guid != new Guid("00000000-0006-0005-0040-000000000000") &&
                                    ni.Definicja.Guid != new Guid("00000000-0006-0005-0044-000000000000") &&
                                    ni.Definicja.Guid != new Guid("00000000-0006-0005-0045-000000000000")) {
                                    if (!okresy.TryGetValue(ni.Okres, out def))
                                        okresy.Add(ni.Okres, ni.Definicja.Nazwa);
                                    else
                                        okresy[ni.Okres] = ni.Definicja.Nazwa;
                                    macieżyński = true;
                                }
                                break;
                        }
                    }
                }

                wynagrodzania.Sort(delegate(WypElement a, WypElement b) { return a.Okres.From.CompareTo(b.Okres.From); });
                zasiłki.Sort(delegate(WypElement a, WypElement b) { return a.Okres.From.CompareTo(b.Okres.From); });
                macieżyńskie.Sort(delegate(WypElement a, WypElement b) { return a.Okres.From.CompareTo(b.Okres.From); });

                if (!macieżyński && !chorobowy && !rehabilitacyjny)
                    macieżyński = chorobowy = rehabilitacyjny = true;

                /// string label7 = "Płatnik składek wypłacił: " +
                ///    Striked("zasiłek chorobowy", chorobowy) + " / " +
                ///    Striked("zasiłek macierzyński", macieżyński) + " / " +
                ///    Striked("świadczenie rehabilitacyjne", rehabilitacyjny);
                /// dlLabel7.EditValue = label7;

                string wynagr = GetElementyInfo(wynagrodzania, false);
                WynagrodzeniaTak.EditValue = wynagr != "" ? "X" : "&nbsp;";
                WynagrodzeniaNie.EditValue = wynagr == "" ? "X" : "&nbsp;";
                Wynagrodzenia.EditValue = wynagr;

                string zas = GetElementyInfo(zasiłki, true);
                ZasilkiTak.EditValue = zas != "" ? "X" : "&nbsp;";
                ZasilkiNie.EditValue = zas == "" ? "X" : "&nbsp;";
                Zasilki.EditValue = zas;

                string mac = GetElementyInfo(macieżyńskie, true);
                MaciezynskieTak.EditValue = mac != "" ? "X" : "&nbsp;";
                MaciezynskieNie.EditValue = mac == "" ? "X" : "&nbsp;";
                Maciezynskie.EditValue = mac;

                string urlopW = "";
                List<FromTo> lw = new List<FromTo>(okresy2.Keys);
                lw.Sort();
                foreach (FromTo ft in lw)
                    if (hash[ft] > 0)
                        urlopW += (urlopW != "" ? "<br/>" : "") + string.Format("{0} - {1}", ft.From, ft.To/*, okresy2[ft]*/);
                
                UrlopWychowawczyTak.EditValue = UrlopWychowawczyNie.EditValue = "&nbsp;";
                //UrlopWychowawczyTak.EditValue = urlopW != "" ? "X" : "&nbsp;";
                //UrlopWychowawczyNie.EditValue = urlopW == "" ? "X" : "&nbsp;";
                UrlopWychowawczy.EditValue = urlopW != "" ? urlopW : "<br/><br/>";

                string urlopM = "";
                List<FromTo> lm = new List<FromTo>(okresy.Keys);
                lm.Sort();
                foreach (FromTo ft in lm)
                    if (hash[ft] > 0)
                        urlopM += (urlopM != "" ? "<br/>" : "") + string.Format("{0} - {1}", ft.From, ft.To/*, okresy[ft]*/);
                UrlopMacierzynski.EditValue = urlopM != "" ? urlopM : "&nbsp;";

                string uwagi = "";
                List<FromTo> lp = new List<FromTo>(hash2.Keys);
                lp.Sort();
                foreach (FromTo ft in lp)
                    if (hash2[ft] > 0) {
                        uwagi += string.Format("<br/>Pracownik w trakcie przebywania na urlopie wychowawczym w dniu {0} nabył prawo do zasiłku macierzyńskiego.", ft.From);
                        break;
                    }
                return uwagi;
            }

            static string Striked(string text, bool ok) {
                if (ok)
                    return text;
                return string.Format("<font size=\"2\" style=\"text-decoration: line-through\">{0}</font>", text);
            }

            void LiczUbezpieczonych(ISessionable session) {
                Date data = pars.Ubezpieczeni;
                KadryModule kadry = KadryModule.GetInstance(session);

                /*int c = 0;
                foreach (Pracownik p in kadry.Pracownicy)
                    if (p[data].Etat.Okres.Contains(data) && p[data].Etat.Ubezpieczenia.Chorobowe.Okres.Contains(data))
                        c++;
                    else 
                        foreach (Umowa u in p.Umowy)
                            if (u.Okres.Contains(data) && u.Ubezpieczenia.Chorobowe.Okres.Contains(data)) {
                                c++;
                                break;
                            }
                UBEZPIECZENI.EditValue = c;*/

                foreach (Pracownik pracownik in kadry.Pracownicy) { }

                Set<Pracownik> pracownicy = new Set<Pracownik>();

                Soneta.Business.View historie = kadry.PracHistorie.WgPracownik.CreateView();
                historie.Condition &= RowCondition.Contains("Aktualnosc", data);
                historie.Condition &= RowCondition.Contains("Etat.Ubezpieczenia.Chorobowe.Okres", data);
                historie.Condition &= RowCondition.Contains("Etat.Okres", data);
                foreach (PracHistoria ph in historie)
                    pracownicy.Add(ph.Pracownik);

                Soneta.Business.View umowy = kadry.Umowy.WgPracownik.CreateView();
                umowy.Condition &= RowCondition.Contains("Ubezpieczenia.Chorobowe.Okres", data);
                umowy.Condition &= RowCondition.Contains("Okres", data);
                foreach (Umowa umowa in umowy)
                    pracownicy.Add(umowa.Pracownik);

                int ilosc = pracownicy.Count;
                foreach (Pracownik pracownik in pracownicy) {
                    PracHistoria ph = pracownik[data];
                    if (ph.Wlasciciel != null && ph.Wlasciciel.IndywidualnaDRA) {
                        ilosc--;
                        continue;
                    }
                    foreach (INieobecnosc n in pracownik.Nieobecnosci.GetIntersectedRows(FromTo.Day(data))) {
                        switch (n.Definicja.Przyczyna) {
                            case PrzyczynaNieobecnosci.UrlopWychowawczy:
                            case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                            case PrzyczynaNieobecnosci.UrlopBezpłatny:
                                ilosc--;
                                break;
                        }
                        break;
                    }
                }
                UbezpieczeniDo20.EditValue = ilosc <= 20 ? "X" : "&nbsp;";
                UbezpieczeniOd21.EditValue = ilosc > 20 ? "X" : "&nbsp;";
            }

            static string PrzyczynyNieobecności(Pracownik pracownik, FromTo okres) {
                Set<string> przyczyny = new Set<string>();
                try {
                    foreach (WypElement e in pracownik.Elementy[okres])
                    {
                        switch (GetZasilkiTyp(e))
                        {
                            case TypPodstawyZasilku.WliczaćDla:
                            case TypPodstawyZasilku.DopełniaćWedługGodzinDla:
                            case TypPodstawyZasilku.DopełniaćWedługDniDla:
                            case TypPodstawyZasilku.DopełniaćJakZasadniczeDla:
                            case TypPodstawyZasilku.WliczaćWNominalnejWysokościDla:
                                break;
                            default:
                                WypElementNieobecność en = e as WypElementNieobecność;
                                if (en != null && en.Nieobecność != null)
                                    przyczyny.Add(en.Nieobecność.KategoriaZUS);
                                break;
                        }

                        if (e is WypElementEtat)
                            foreach (WypSkladnik s in e.Skladniki)
                                if (s is WypSkladnikPomniejszenie && s.Nieobecnosc != null && s.Nieobecnosc.Definicja.Rozliczenie == Soneta.Kalend.RozliczenieNieobecnosci.Brak)
                                    przyczyny.Add(s.Nieobecnosc.KategoriaZUS);
                    }
                }
                catch { Msg(); }

                string result = "";
                foreach (string s in przyczyny)
                    result += (result == "" ? "" : ";") + s;
                return result;
            }

            string StripHTML(string HTMLText) {
                var reg = new Regex("<[^>]+>", RegexOptions.IgnoreCase);
                return reg.Replace(HTMLText, "");
            }

            void SetHeader() {
                IPieczątkaFirmy pf = ReportHeader.GetPieczątka(dc);
                dlFirma.EditValue = string.Format("<strong>{0}</strong>", pf.NazwaFormatowana);
                dlAdres1.EditValue = pf.Adres.Linia1;
                dlAdres2.EditValue = pf.Adres.Linia2;
                dlNIP.EditValue = string.Format("NIP: {0}", pf.NIP);
                BusinessModule bm = BusinessModule.GetInstance(dc.Session);
                ReportsLeaf rf = bm.Config.Reports.Defaults;
                string strip = StripHTML(rf.Postscript);
                dlDodatkowe.EditValue = "<font size='1pt'>" + strip + "</font><br/>";
                dlDodatkowe.Visible = !string.IsNullOrEmpty(strip);
            }

            static bool nieusprawiedliwiona = false;
            void OnContextLoad(Object sender, EventArgs args) {
                SetHeader();
                report = dlTitle;

                nieWliczaneDoPodstawy.Clear();

                INieobecnoscLubZbieg nieobecnosc = pars.Nieobecność;
                if (nieobecnosc.Definicja.Typ!=TypNieobecnosci.NieobecnośćZUS)
                    throw new RowException(nieobecnosc, "Zaświadczenie może być drukowane tylko dla nieobecności ZUS.");
                PracHistoria ph = nieobecnosc.PracHistoria;
                Pracownik pracownik = nieobecnosc.Pracownik;

                LiczDaneFirmy(ph);
                LiczDanePracownika(ph);
                LiczOkresyUbezpieczenia(nieobecnosc, ph);
                string uwagi = LiczWynagrodzeniaZasiłki(pracownik);
                LiczUbezpieczonych(ph);
                NrRachunku.EditValue = pars.RachBank != null ? pars.RachBank : "&nbsp;";

                if (nieobecnosc is Nieobecnosc && nieobecnosc.Zwolnienie.ZwolnienieDostarczone != Date.Empty) {
                    ZasLekTak.EditValue = "X";
                    ZasLekNie.EditValue = "&nbsp;";
                    ZasLekData.EditValue = nieobecnosc.Zwolnienie.ZwolnienieDostarczone.ToString();
                }
                else {
                    ZasLekTak.EditValue = "&nbsp;";
                    ZasLekNie.EditValue = "X";
                    ZasLekData.EditValue = "&nbsp;";
                }

                ZasDokTak.EditValue = ZasDokNie.EditValue = "&nbsp;";
                if (nieobecnosc is Nieobecnosc && nieobecnosc.Zwolnienie.Numer != "") {
                    //ZasDokTak.EditValue = "X";
                    //ZasDokNie.EditValue = "&nbsp;";
                    ZasDokNumer.EditValue = nieobecnosc.Zwolnienie.Numer;
                }
                else {
                    //ZasDokTak.EditValue = "&nbsp;";
                    //ZasDokNie.EditValue = "X";
                    ZasDokNumer.EditValue = "&nbsp;";
                }

                ZatrDo.EditValue = ph.Etat.OkresZatrudnienia.To == Date.MaxValue ?
                    "" : "- " + ph.Etat.OkresZatrudnienia.To;

                Fraction współczynnik = pars.Współczynnik;

                //Miesięczne
                ArrayList miesiąc = new ArrayList();
                try {
                    foreach (WypElement e in pracownik.Elementy[pars.Okres])
                        if (RodzajOkresu(e.Okres)==1)
                            miesiąc.Add(e);
                }
                catch { Msg(); }

                Grid2.DataSource = LiczMiesiące(ph, miesiąc, współczynnik);

                //Okresowe
                ArrayList kwartał = new ArrayList();
                ArrayList rok = new ArrayList();
                ArrayList inne = new ArrayList();
                try {
                    foreach (WypElement e in pracownik.Elementy[pars.Okresowe]) {
                        switch (RodzajOkresu(e.Okres)) {
                            case 1:
                                break;
                            case 3:
                                kwartał.Add(new SumKwartał(e, współczynnik));
                                break;
                            case 12:
                                rok.Add(new SumRok(e, współczynnik));
                                break;
                            default:
                                inne.Add(new SumInne(e, współczynnik));
                                break;
                        }
                    }
                }
                catch { Msg(); }

                Grid3.DataSource = Clear(kwartał);

                rok.Sort();
                Grid4.DataSource = Clear(rok);

                inne.Sort();
                Grid5.DataSource = Clear(inne);

                if (nieWliczaneDoPodstawy.Count > 0) {
                    List<string> lst = new List<string>(nieWliczaneDoPodstawy.Keys);
                    lst.Sort();
                    string ss = "";
                    foreach (string s in lst)
                        if (ss == "")
                            ss = s;
                        else
                            ss = ", " + s;
                    uwagi += (uwagi != "" ? "<br/>" : "") +
                        string.Format("W pkt. 10 w kolumnie 8 zostały wykazane składniki wynagrodzenia, do których pracownik zachowuje prawo za okres pobierania zasiłku ({0}).", ss);
                }

                Fraction fw = Fraction.Zero;
                FromTo ow = PoprzedniWymiar(ph, ref fw);
                if (ow != FromTo.Empty)
                    uwagi += (uwagi != "" ? "<br/>" : "") +
                         string.Format("Poprzedni wymiar etatu: {0} w okresie {1}", fw, ow);
                if (nieusprawiedliwiona)
                    uwagi += (uwagi != "" ? "<br/>" : "") +
                         "Kwota wynagrodzenia w pkt 11 uzupełniona została tylko o dni usprawiedliwionej nieobecności w pracy.";
                if (string.IsNullOrEmpty(uwagi)) uwagi = "<br /><br /><br /><br />";
                dlUwagi.EditValue = uwagi.ToUpper();
            }

            ArrayList Clear(ArrayList lista) {
                ArrayList result = new ArrayList();
                foreach (SumOkresowy okr in lista)
                    if (okr.Kwota != 0)
                        result.Add(okr);
                return result;
            }

            public static void Msg(object obj) {
            }

            public static DataLabel report;

            public static void Msg() {
                string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
                if (!report.EditValue.ToString().Contains(msg))
                    report.EditValue = msg;
            }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Times New Roman">
		<form id="DeklaracjaZ3" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kalend.INieobecnoscLubZbieg,Soneta.KadryPlace"></ea:datacontext>

            <ea:SectionMarker ID="SectionMarker9" runat="server"></ea:SectionMarker>
		    <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" 
			    ResetPageCounter="True"></ea:PageBreak>
            <ea:Section runat="server" SectionType="Header"></ea:Section>
            <ea:Section runat="server" SectionType="Body">


            <p align="right">
                <b>ZUS Z-3</b>
            </p>

            <table cellSpacing="0" width="100%" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-family: tahoma; text-align:left;">
			    <tr>
            		<td width="35%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-size: 9pt;">
				        <ea:datalabel id="dlFirma" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlAdres1" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlAdres2" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlNIP" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlDodatkowe" runat="server" Bold="false"></ea:datalabel>
                        ....................................................................<br />
                        Pieczątka płatnika składek,  jeśli ją posiadasz<br /> 
                    </td>
                </tr>
            </table>
            <br />

            <p align="center">
                <b>ZAŚWIADCZENIE PŁATNIKA SKŁADEK</b><br />
                <ea:datalabel id="dlTitle" runat="server" Bold="false"></ea:datalabel>
            </p>

            <font face="Tahoma" size="2">
                <p style="text-align:left">
                    <u><b>Instrukcja wypełniania</b></u><br />
                </p>
                Wypełnij to zaświadczenie i przekaż je do nas, jeśli Twojemu pracownikowi mamy ustalić prawo do zasiłku
                chorobowego, zasiłku opiekuńczego, zasiłku macierzyńskiego, zasiłku w wysokości zasiłku macierzyńskiego,
                zasiłku wyrównawczego lub świadczenia rehabilitacyjnego.<br />
                <ol>
                    <li>Wypełnij WIELKIMI LITERAMI</li>
                    <li>Pola wyboru zaznacz znakiem <b>X</b></li>
                    <li>Wypełnij kolorem czarnym lub niebieskim (nie ołówkiem)</li>
                    <li>Zanim wypełnisz zaświadczenie, zapoznaj się z <b>Pouczeniem</b></li>
                </ol>
            </font>

            <font face="Tahoma" size="2">
                <u><b>Dane płatnika składek</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">

					<TR>
						<TD width="35%" align="right"><FONT size="2">NIP</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNIP" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer REGON</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaREGON" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie podałeś NIP, podaj REGON</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaPESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie masz nadanego NIP i REGON, podaj PESEL</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="FirmaRodzaj" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="FirmaDokument" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie masz nadanego NIP, REGON i PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa albo imię i nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNazwa" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaKodP" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="FirmaMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="FirmaKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>

            <font face="Tahoma" size="2">
                <u><b>Dane osoby ubezpieczonej</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego PESEL, podaj serię i numer dokumentu potwierdzającego tożsamość</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="PracImie" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="PracNazwisko" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Pracownik występuje o:</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="30%">
                            <FONT size="2">[ ] zasiłek chorobowy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>

						<TD width="30%">
                            <FONT size="2">[ ] zasiłek opiekuńczy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">[ ] zasiłek macierzyński</FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%">
                            <FONT size="2">[ ] zasiłek w wysokości zasiłku macierzyńskiego</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>

						<TD width="30%">
                            <FONT size="2">[ ] zasiłek wyrównawczy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>

						<TD width="30%">
                            <FONT size="2">[ ] świadczenie rehabilitacyjne</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
                        <TD width="15%">
                            <FONT size="2">za okres:</FONT>
                        </TD>
						<TD width="85%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
                        <TD width="15%"></TD>
                        <TD width="85%">
                            <FONT size="1"><i>Podaj okres od–do</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
            </font>

			<ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Informacje o zaświadczeniach lekarskich</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Wypełnij, gdy pracownik wystąpił o zasiłek chorobowy lub zasiłek opiekuńczy z powodu opieki nad chorym dzieckiem lub innym chorym członkiem rodziny</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">1. Czy załączasz zaświadczenie lekarskie</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasLekTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasLekNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="ZasLekData" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
                        <TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj datę, kiedy wpłynęło do płatnika składek</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">2. Czy zaświadczenie lekarskie zostało wystawione w formie elektronicznej (e-ZLA)</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasDokTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasDokNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="ZasDokNumer" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
                        <TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj, jeśli znasz – serię i numer zaświadczenia lekarskiego</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Informacje o pracowniku</b></u><br/>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="30%">
                            <FONT size="2">1. Jest zatrudniony</FONT>
						</TD>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
						        <ea:DataLabel id="ZatrOd" runat="server" DataMember="PracHistoria.Etat.OkresZatrudnienia.From"></ea:DataLabel>
						        <ea:DataLabel id="ZatrDo" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%"></TD>
                        <TD width="70%">
                            <FONT size="1"><i>Podaj datę, od kiedy jest zatrudniony lub okres zatrudnienia od–do</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="30%">
                            <FONT size="2">&nbsp;&nbsp;&nbsp;w wymiarze czasu pracy</FONT>
						</TD>
						<TD width="33%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
						        <ea:DataLabel id="DataLabel12" runat="server" DataMember="PracHistoria.Etat.Zaszeregowanie.Wymiar"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
						<TD width="4%">&nbsp;</TD>
						<TD width="33%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
						        <ea:DataLabel runat="server" id="WymiarFrom"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="30%"></TD>
                        <TD width="33%">
                            <FONT size="1"><i>Podaj wymiar czasu pracy</i></FONT>
                        </TD>
						<TD width="4%"></TD>
                        <TD width="33%">
                            <FONT size="1"><i>Podaj datę, od kiedy (dd/mm/rrrr)</i></FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">2. Czy jest zatrudniony na podstawie umowy o pracę tymczasową</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZatrTymczTak" runat="server"></ea:DataLabel>] TAK</FONT>
                        </TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZatrTymczNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">3. Czy wykonuje pracę za granicą</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZatrZagrTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZatrZagrNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">4. Czy niezdolność do pracy powstała z powodu</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="25%">
                            <FONT size="2">[ ] choroby zawodowej</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="25%">
                            <FONT size="2">[ ] wypadku przy pracy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="40%">
                            <FONT size="2">[ ] wypadku w drodze do pracy lub z pracy</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="10%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="70%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj dokument potwierdzający (decyzja/ protokół karta wypadku), numer oraz datę jego sporządzenia</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">5. Czy w okresie niezdolności do pracy z powodu choroby, sprawowania opieki lub macierzyństwa</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] korzysta z urlopu bezpłatnego</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] przebywa w areszcie tymczasowym</FONT>
						</TD>
                    </TR>
                    <TR>
						<TD width="45%">&nbsp;</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">&nbsp;</TD>
                    </TR>
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] korzysta z urlopu wychowawczego</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] odbywa karę pozbawienia wolności</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="10%"><FONT size="2">
                                [<ea:DataLabel ID="UrlopWychowawczyTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">
                                [<ea:DataLabel ID="UrlopWychowawczyNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="UrlopWychowawczy" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="70%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">6. Pracownikowi udzielono <i>(wypełnij, jeśli pracownik występuje o zasiłek macierzyński)</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] urlopu macierzyńskiego</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] urlopu rodzicielskiego</FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="45%">&nbsp;</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">&nbsp;</TD>
                    </TR>
					<TR>
						<TD width="45%">
                            <FONT size="2">[ ] urlopu na warunkach urlopu macierzyńskiego</FONT>
						</TD>
						<TD width="10%">&nbsp;</TD>
						<TD width="45%">
                            <FONT size="2">[ ] urlopu ojcowskiego</FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
						        <ea:DataLabel id="UrlopMacierzynski" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Podaj okres od–do oraz datę wniosku</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">7. Czy pracownik w czasie urlopu rodzicielskiego wykonuje pracę u swojego pracodawcy</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okres od–do oraz wymiar czasu pracy</i></FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>

			<ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Informacje o wypłaconych świadczeniach</b></u><br/>
            <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">1. Czy wypłaciłeś wynagrodzenie za okresy orzeczonej niezdolności do pracy w danym roku kalendarzowym na podstawie art. 92 Kodeksu pracy</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                                [<ea:DataLabel ID="WynagrodzeniaTak" runat="server"></ea:DataLabel>] TAK</FONT>
                        </TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                                [<ea:DataLabel ID="WynagrodzeniaNie" runat="server"></ea:DataLabel>] NIE</FONT>
                        </TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
						        <ea:DataLabel id="Wynagrodzenia" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz kod literowy. Podaj także okresy wynagrodzenia wypłaconego w poprzednim roku, wliczane do jednego okresu zasiłkowego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">2. Czy wypłaciłeś zasiłek chorobowy / świadczenie rehabilitacyjne</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasilkiTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="ZasilkiNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="Zasilki" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz kod literowy. Podaj okresy wliczone do jednego okresu zasiłkowego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="80%">
                            <FONT size="2">3. Czy wypłaciłeś zasiłek macierzyński</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="MaciezynskieTak" runat="server"></ea:DataLabel>] TAK</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">
                            [<ea:DataLabel ID="MaciezynskieNie" runat="server"></ea:DataLabel>] NIE</FONT>
						</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel ID="Maciezynskie" runat="server"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="100%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj okresy od–do oraz stawkę % zasiłku macierzyńskiego</i></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
            </font>
            <br />

            <font face="Tahoma" size="2">
            <u><b>Pozostałe informacje</b></u><br/>
            <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="40%">
                            <FONT size="2">Czy zgłosiłeś do ubezpieczenia chorobowego</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="25%"><FONT size="2">
                            [<ea:DataLabel ID="UbezpieczeniDo20" runat="server"></ea:DataLabel>] do 20 ubezpieczonych</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="31%"><FONT size="2">
                            [<ea:DataLabel ID="UbezpieczeniOd21" runat="server"></ea:DataLabel>] powyżej 20 ubezpieczonych</FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak4" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Informacje o składnikach wynagrodzenia</b></u><br/>
            <br />
				1. Składniki wynagrodzenia za okresy miesięczne
			    <ea:grid id="Grid2" runat="server">
				    <Columns>
					    <ea:GridColumn Width="10" Align="Center" DataMember="Miesiąc.Year" Caption="Rok<br/>(1)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="11" Align="Center" DataMember="Miesiąc.Month" Caption="Miesiąc<br/>(2)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Praca" Caption="Liczba dni, kt&#243;re pracownik:~przepracował<br/>(3)"
						    Format="{0:00}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Norma" Caption="Liczba dni, kt&#243;re pracownik:~był obowiązany przepracować<br/>(4)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="10" Align="Center" DataMember="Przyczyna" Caption="Przyczyna nieprzeprac. całego miesiąca<br/>(5)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="14" Align="Right" DataMember="Zasadnicze" Caption="Stałe wynagrodzenie zasadnicze i inne składniki stałe w pełnej miesięcznej wysokości określonej w umowie o pracę brutto<br/>(6)"
						    Format="{0:n}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Right" DataMember="Proporcjonalne" Caption="Zmienne wynagrodzenie miesięczne brutto~wynagrodz. zasadnicze i inne składniki pomniejszane proporcjonaln.<br/>(7)"
						    Format="{0:n}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="10" Align="Right" DataMember="Faktyczne" Caption="Zmienne wynagrodzenie miesięczne brutto~premie i inne składniki uwzględn. w kwocie faktycznej<br/>(8)"
						    Format="{0:n}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="10" Align="Right" DataMember="Procent" Caption="Procent składki potrąconej<br/>(9)" Format="{0:n}%" runat="server"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
            </font>
            <br />

			<ea:PageBreak id="PageBreak5" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
				2. Składniki wynagrodzenia za okresy kwartalne
			    <ea:grid id="Grid3" runat="server">
				    <Columns>
					    <ea:GridColumn Width="10" Align="Center" DataMember="Rok" Caption="Rok<br/>(1)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="11" Align="Center" DataMember="Kwartał" Caption="Kwartał<br/>(2)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Caption="Kwota<br/>(3)" Format="{0:n}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Praca" Caption="Liczba dni, kt&#243;re pracownik:~przepracował<br/>(4)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Norma" Caption="Liczba dni, kt&#243;re pracownik:~był obowiązany przepracować<br/>(5)" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Przyczyna&lt;br&gt;nieprzepracowania&lt;br&gt;całego kwartału<br/>(6)"
                            Width="18" DataMember="Przyczyna" Align="Center">
                        </ea:GridColumn>
					    <ea:GridColumn Width="10" Align="Right" DataMember="Procent" Caption="Procent składki potrąconej<br/>(7)" Format="{0:n}%" runat="server"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
            </font>
            <br />

			<ea:PageBreak id="PageBreak6" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
                3. Składniki wynagrodzenia za okresy roczne
			    <ea:grid id="Grid4" runat="server">
				    <Columns>
					    <ea:GridColumn Width="21" Align="Center" DataMember="Rok" Caption="Rok<br/>(1)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Caption="Kwota<br/>(2)" Format="{0:n}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Praca" Caption="Liczba dni, kt&#243;re pracownik:~przepracował<br/>(3)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Norma" Caption="Liczba dni, kt&#243;re pracownik:~był obowiązany przepracować<br/>(4)" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Przyczyna&lt;br&gt;nieprzepracowania&lt;br&gt;całego roku<br/>(5)"
                            Width="18" DataMember="Przyczyna" Align="Center">
                        </ea:GridColumn>
					    <ea:GridColumn Width="10" Align="Right" DataMember="Procent" Caption="Procent składki potrąconej<br/>(6)" Format="{0:n}%" runat="server"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
            </font>
            <br />

			<ea:PageBreak id="PageBreak7" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
				4. Składniki wynagrodzenia za inne okresy
			    <ea:grid id="Grid5" runat="server">
				    <Columns>
					    <ea:GridColumn Width="21" Align="Center" DataMember="Okres" Caption="Okres<br/>(1)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Caption="Kwota<br/>(2)" Format="{0:n}" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Praca" Caption="Liczba dni, kt&#243;re pracownik:~przepracował<br/>(3)" runat="server"></ea:GridColumn>
					    <ea:GridColumn Width="12" Align="Center" DataMember="Norma" Caption="Liczba dni, kt&#243;re pracownik:~był obowiązany przepracować<br/>(4)" runat="server"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Przyczyna&lt;br&gt;nieprzepracowania&lt;br&gt;danego okresu<br/>(5)"
                            Width="18" DataMember="Przyczyna" Align="Center">
                        </ea:GridColumn>
					    <ea:GridColumn Width="10" Align="Right" DataMember="Procent" Caption="Procent składki potrąconej<br/>(6)" Format="{0:n}%" runat="server"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
            </font>
            <br />

			<ea:PageBreak id="PageBreak8" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%">
                            <FONT size="2">5. Czy z pracownikiem jest zawarta umowa zlecenia, umowa agencyjna lub inna umowa o świadczenie usług, do której
                                zgodnie z Kodeksem cywilnym stosuje się przepisy dotyczące zlecenia albo umowa o dzieło lub inna umowa, czy
                                przysługuje pracownikowi składnik wynagrodzenia przyznany do określonego terminu?
                            </FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="10%">
                            <FONT size="2">[ ] TAK</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%">
                            <FONT size="2">[ ] NIE</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><br /><br /></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="10%"></TD>
						<TD width="5%"></TD>
						<TD width="70%">
                            <FONT size="1"><i>Jeśli <b>TAK</b>, podaj datę, do której zawarta jest umowa zlecenia (lub inna) – podaj datę, do której składnik przysługuje oraz podaj kwotę wynagrodzenia z tych tytułów za poszczególne miesiące</i></FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak9" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Uwagi:</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="dlUwagi" runat="server" Bold="False"></ea:DataLabel>
                                <br /><br />
                            </FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak10" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
            <u><b>Rachunek bankowy</b></u><br/>
                <font face="Tahoma" size="1">
                    <i>Podaj rachunek bankowy pracownika</i>
                </font>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%">
					<TR>
						<TD width="100%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="NrRachunku" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
				</TABLE>
            </font>
            <br />

			<ea:PageBreak id="PageBreak11" runat="server" Required="False"></ea:PageBreak>

            <font face="Tahoma" size="2">
                <b>Oświadczam, że dane zawarte w zaświadczeniu podałem zgodnie z prawdą.
                    Jeżeli ulegną one zmianie, zobowiązuję się poinformować o nich ZUS.</b><br/>
            </font>
            <br />

			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="Data: dd/mm/rrrr" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Podpis upoważnionego pracownika, nr telefonu oraz pieczątka zawierająca imię, nazwisko i stanowisko" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>

			<ea:PageBreak id="PageBreak12" runat="server" Required="True"></ea:PageBreak>

            <p align="right">
                <b>ZUS Z-3</b>
            </p>
			<P style="text-align: center"><FONT size="2"><strong>POUCZENIE</strong></FONT></P>
            <p style="text-align: justify">
                <font size="2">
                    <b>Podstawa prawna: ustawa z dnia 25 czerwca 1999 r. o świadczeniach pieniężnych z ubezpieczenia społecznego w razie
                    choroby i macierzyństwa, ustawa z dnia 30 października 2002 r. o ubezpieczeniu społecznym z tytułu wypadków przy pracy
                    i chorób zawodowych oraz rozporządzenie Ministra Rodziny, Pracy i Polityki Społecznej z 8 grudnia 2015 r. w sprawie
                    zakresu informacji o okolicznościach mających wpływ na prawo do zasiłków z ubezpieczenia społecznego w razie choroby
                    i macierzyństwa lub ich wysokość oraz dokumentów niezbędnych do przyznania i wypłaty zasiłków.</b>
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Informacje wstępne</i></b>
                </font>
                <br /><br />
                <font size="2">
                    Pracownicy nabywają prawo do zasiłku chorobowego z ubezpieczenia chorobowego po upływie 30 dni nieprzerwanego
                    ubezpieczenia chorobowego. Do 30-dniowego okresu nieprzerwanego ubezpieczenia chorobowego wlicza się poprzednie okresy
                    ubezpieczenia chorobowego, jeżeli przerwa między nimi nie przekroczyła 30 dni lub była spowodowana urlopem bezpłatnym,
                    urlopem wychowawczym albo odbywaniem czynnej służby wojskowej przez żołnierza niezawodowego. Trzydziestodniowy okres
                    wyczekiwania na prawo do zasiłku chorobowego nie obowiązuje:<br />
                    - absolwentów szkół oraz szkół wyższych, którzy zostali objęci ubezpieczeniem chorobowym w ciągu 90 dni od dnia ukończenia
                    szkoły lub uzyskania dyplomu ukończenia studiów wyższych,<br />
                    - osób, których niezdolność do pracy została spowodowana chorobą zawodową, wypadkiem przy pracy, wypadkiem w drodze
                    do pracy lub z pracy,<br />
                    - ubezpieczonych obowiązkowo, którzy mają wcześniejszy co najmniej 10-letni okres obowiązkowego ubezpieczenia
                    chorobowego (również ubezpieczenia społecznego przed dniem 1 stycznia 1999 r.),<br />
                    - posłów i senatorów, którzy przystąpili do ubezpieczenia chorobowego w ciągu 90 dni od ukończenia kadencji.<br />
                    Jeżeli niezdolność do pracy powstała przed upływem 30 dni nieprzerwanego ubezpieczenia chorobowego, pracownik powinien
                    udokumentować okoliczności, które wyłączają obowiązek wyczekiwania lub potwierdzają posiadanie poprzednich okresów
                    ubezpieczenia.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o zaświadczeniach lekarskich</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Do pkt. 1</b>
                    <br />
                    Załącz zaświadczenie lekarskie, jeśli zostało wystawione pracownikowi na druku ZUS ZLA, na zasadach obowiązujących do
                    31 grudnia 2015 r.<br />
                    Pracownik powinien dostarczyć zaświadczenie lekarskie na druku ZUS ZLA do pracodawcy w ciągu 7 dni od jego wystawienia.
                    Jeżeli ten termin zostanie przekroczony, zasiłek chorobowy jest obniżany o 25%, od 8 dnia orzeczonej niezdolności do pracy do
                    dnia dostarczenia zaświadczenia lekarskiego.<br />
                    W przypadku kolejnego zaświadczenia lekarskiego wystawionego na druku ZUS ZLA za okres dalszej, nieprzerwanej niezdolności
                    do pracy nie przesyłaj ponownie zaświadczenia płatnika składek Z-3, podaj jednak datę dostarczenia przez pracownika
                    zaświadczenia lekarskiego ZUS ZLA oraz, czy tytuł ubezpieczenia, jak również ubezpieczenie chorobowe lub wypadkowe trwa
                    nadal. Informacje te poświadcz pieczątką i podpisem.
                    <br /><br />
                    <b>Do pkt. 2</b>
                    <br />
                    Jeśli zaświadczenie lekarskie zostało wystawione pracownikowi w formie elektronicznej (e-ZLA), podaj tylko jego serię oraz
                    numer (jeżeli je znasz). Jeśli zaświadczenie lekarskie zostało wystawione pracownikowi elektronicznie, nie obowiązują terminy
                    na jego dostarczenie.<br />
                    W przypadku kolejnego zaświadczenia lekarskiego wystawionego elektronicznie za okres nieprzerwanej niezdolności do pracy,
                    prześlij do ZUS zaświadczenie płatnika składek Z-3, wypełnione do pkt. 1 sekcji Informacje o pracowniku włącznie.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o pracowniku</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Do pkt. 1</b>
                    <br />
                    Wpisz datę początku i końca zatrudnienia (dzień, miesiąc, rok). W przypadku gdy zatrudnienie trwa, wpisz tylko datę początkową.
                    <br /><br />
                    <b>Do pkt. 4</b>
                    <br />
                    Wypłaty świadczeń z tytułu wypadku przy pracy albo wypadku w drodze do pracy lub z pracy ZUS dokonuje po uprzednim
                    uznaniu zdarzenia za taki wypadek, dlatego też do wniosku dołącz niezbędną dokumentację wypadkową. W przypadku choroby
                    zawodowej dołącz decyzję o stwierdzeniu choroby zawodowej i zaświadczenie lekarza, które stwierdza, że niezdolność do pracy
                    pracownika jest spowodowana chorobą zawodową.
                    <br /><br />
                    <b>Do pkt. 6</b>
                    <br />
                    W przypadku gdy zaświadczenie płatnika składek dotyczy zasiłku macierzyńskiego, wpisz okres udzielonego urlopu
                    macierzyńskiego, urlopu na warunkach urlopu macierzyńskiego, urlopu rodzicielskiego lub urlopu ojcowskiego.<br />
                    Jeżeli urlop rodzicielski/ urlop ojcowski udzielany jest w więcej niż jednej części, wpisz okresy urlopów udzielonych w tych
                    częściach oraz datę złożenia wniosków o poszczególne części urlopu rodzicielskiego.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o wypłaconych świadczeniach</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Do pkt. 1</b>
                    <br />
                    Jeżeli w poprzednim roku kalendarzowym wypłaciłeś pracownikowi wynagrodzenie chorobowe na podstawie art. 92 Kodeksu
                    pracy, za okresy wliczane do jednego okresu zasiłkowego, podaj również okresy wypłaty wynagrodzenia w poprzednim roku.
                    <br /><br />
                    <b>Do pkt. 1 i 2</b>
                    <br />
                    Do jednego okresu zasiłkowego wlicza się wszystkie okresy nieprzerwanej niezdolności do pracy, oraz okresy przedzielone
                    przerwą, o ile przerwa pomiędzy ustaniem poprzedniej a powstaniem ponownej niezdolności do pracy, która jest spowodowana
                    tą samą chorobą lub tą samą przyczyną, nie przekraczała 60 dni.
                    <br /><br />
                    <b>Do pkt. 3</b>
                    <br />
                    Jeśli na podstawie art. 177 § 3 Kodeksu pracy umowa o pracę została przedłużona do dnia porodu, a płatnik składek byłby
                    zobowiązany do wypłaty zasiłku macierzyńskiego tylko za jeden dzień, wypłaty zasiłku za cały okres dokonuje ZUS.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Pozostałe informacje</i></b>
                </font>
                <br /><br />
                <font size="2">
                    Liczbę ubezpieczonych, ustala się według stanu na dzień 30 listopada poprzedniego roku kalendarzowego, a w stosunku do
                    płatników składek, którzy na ten dzień nie zgłaszali nikogo do ubezpieczenia chorobowego, według stanu na pierwszy miesiąc,
                    w którym dokonali takiego zgłoszenia.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Informacje o składnikach wynagrodzenia</i></b>
                </font>
                <br /><br />
                <font size="2">
                    <b>Informacje ogólne:</b>
                    <br />
                    W tabelach podaj kwoty składników wynagrodzenia niepomniejszone o składki na ubezpieczenia społeczne. Pomniejszenia tego
                    dokona ZUS podczas obliczania podstawy wymiaru zasiłku.<br />
                    Podaj wyłącznie składniki wynagrodzenia uwzględniane przy obliczaniu podstawy wymiaru zasiłku. Nie wykazuj takich składników
                    wynagrodzenia, do których pracownik zachowuje prawo za okres pobierania zasiłku i które są mu wypłacane za okres pobierania
                    zasiłku oraz składników wynagrodzenia, na których przyznanie i wypłatę pobieranie zasiłków nie ma żadnego wpływu, takich jak:
                    jednorazowe zasiłki na zagospodarowanie, wartość szczepień ochronnych fi nansowanych przez pracodawcę, wartość badań
                    mammografi cznych lub innych nieodpłatnych badań, nagrody za ukończenie przez pracownika szkoły (studiów), sfi nansowanie
                    lub dofi nansowanie przez pracodawcę kosztów wynajmu mieszkania przez pracownika, dopłata pracodawcy do dodatkowego
                    ubezpieczenia pracownika z tytułu różnych ryzyk, bony lub wypłaty w gotówce przyznawane w jednakowej wysokości lub według
                    jednakowego wskaźnika procentowego w stosunku do płacy pracownika, określonej w umowie o pracę, wszystkim pracownikom
                    lub grupom pracowników, z okazji uroczystych dni, świąt, rocznicy powstania fi rmy itp. Jeśli zasiłek przysługuje za okres po
                    ustaniu zatrudnienia, podaj wszystkie składniki wynagrodzenia, które stanowiły podstawę wymiaru składek na ubezpieczenie
                    chorobowe pracownika, także te do których pracownik zachowywał prawo za okres pobierania zasiłku oraz na których przyznanie
                    i wypłatę pobieranie zasiłków nie miało wpływu.<br />
                    Wynagrodzenie za urlop wypoczynkowy traktuje się na równi z wynagrodzeniem za pracę.<br />
                    Składniki wynagrodzenia, które przysługują do określonego terminu uwzględnia się w podstawie wymiaru zasiłku, który przysługuje
                    tylko do tego terminu. W związku z tym w tabelach nie podawaj składników przyznanych do określonego terminu, jeżeli zasiłek
                    przysługuje za okres po upływie tego terminu. Jeżeli okres, do którego składnik jest przyznany nie upłynął przed rozpoczęciem
                    niezdolności do pracy, podaj w pkt. 5 okres, do którego składnik wynagrodzenia przysługuje, oraz jego kwotę.
                    <br /><br />
                    <b>Do pkt. 1 (tabela Składniki wynagrodzenia za okresy miesięczne)</b>
                    <br />
                    Podaj wynagrodzenie wypłacone pracownikowi za okres 12 miesięcy kalendarzowych poprzedzających miesiąc, w którym
                    powstała nieprzerwana niezdolność do pracy. Jeśli pracownik przed okresem tej nieprzerwanej niezdolności do pracy pobierał
                    zasiłek albo wynagrodzenie chorobowe oraz przerwa między okresami pobierania zasiłku/ wynagrodzenia chorobowego była
                    krótsza niż 3 miesiące kalendarzowe, podaj wynagrodzenie za okres poprzedzający miesiąc, w którym powstała najwcześniejsza
                    z niezdolności do pracy. W razie zmiany wymiaru czasu pracy w okresie 12 miesięcy kalendarzowych poprzedzających powstanie
                    niezdolności do pracy albo w miesiącu, w którym powstała niezdolność do pracy, podaj wynagrodzenie tylko za pełne kalendarzowe
                    miesiące po zmianie wymiaru czasu pracy. Wynagrodzenie określone dla nowego wymiaru czasu pracy podaj również, jeśli
                    pomiędzy okresami pobierania zasiłków zarówno tego samego rodzaju, jak i innego rodzaju nie było przerwy albo przerwa była
                    krótsza niż 3 miesiące kalendarzowe.<br />
                    Jeżeli pracownik otrzymuje wynagrodzenie zasadnicze lub inne składniki miesięczne w stałej wysokości, w tym wynagrodzenie
                    godzinowe, w kolumnie 6 tabeli podaj je w pełnej kwocie określonej w umowie o pracę lub innym akcie nawiązującym
                    stosunek pracy.<br />
                    W przypadku pracownika tymczasowego podaj kwotę ustaloną odpowiednio do okresu umowy o pracę tymczasową.
                    W przypadku pracownika, który wykonuje pracę za granicą, kwoty które są podstawą wymiaru składki na ubezpieczenie chorobowe
                    wykaż bez uzupełnienia.<br />
                    Jeżeli w miesiącu, z którego wynagrodzenie jest uwzględniane przy ustalaniu podstawy wymiaru zasiłku, przychód pracownika
                    przekroczył roczną podstawę wymiaru składek na ubezpieczenia emerytalne i rentowe, oblicz średni wskaźnik potrąconej
                    pracownikowi za ten miesiąc składki na ubezpieczenia społeczne w następujący sposób:
                    <br /><br />
                    <table width="100%" style="font-size: 8pt; font-family: Tahoma; text-align: center">
                        <tr align="center">
                            <td width="30%">&nbsp;</td>
                            <td style="border-bottom: thin solid; text-align: center">
                                kwota potrąconej składki x 100
                            </td>
                            <td width="30%">&nbsp;</td>
                        </tr>
                        <tr align="center">
                            <td width="30%">&nbsp;</td>
                            <td style="text-align: center">
                                przychód stanowiący podstawę wymiaru składek
                            </td>
                            <td width="30%">&nbsp;</td>
                        </tr>
                    </table>
                    <br />
                    Jeżeli pracownik otrzymuje wynagrodzenie zmienne:<br />
                    - w kolumnie 7 tabeli podaj wynagrodzenie zasadnicze i inne składniki wynagrodzenia, które są pomniejszane proporcjonalnie za
                    okres pobierania zasiłku i w związku z tym w podstawie wymiaru zasiłku będą uwzględnione po uprzednim uzupełnieniu przez ZUS,<br />
                    - w kolumnie 8 tabeli podaj składniki wynagrodzenia, które są zmniejszane za okres pobierania zasiłku w inny sposób niż
                    proporcjonalnie i w związku z tym w podstawie wymiaru zasiłku będą uwzględnione w kwocie faktycznie wypłaconej bez
                    uzupełniania, np. wynagrodzenie za pracę w godzinach nadliczbowych wraz z dopłatami.
                    <br /><br />
                    <b>Do pkt. 2, 3, 4 (tabela Składniki wynagrodzeń za okresy kwartalne, roczne oraz inne okresy)</b>
                    <br />
                    W tabelach zamieszczonych w pkt. 2, 3, 4, kolumny dotyczące liczby dni, które pracownik przepracował lub był obowiązany
                    przepracować, wypełnij tylko wtedy, gdy składnik wynagrodzenia odpowiednio kwartalny, roczny lub za inne okresy jest składnikiem
                    pomniejszanym proporcjonalnie za okresy pobierania zasiłku.
                    <br /><br />
                    <b>Do pkt. 5 (dane o wynagrodzeniu z tytułu wykonywania umowy zlecenia, umowy agencyjnej lub innej umowy o świadczenie
                    usług oraz o składnikach wynagrodzenia, które przysługują pracownikowi do określonego terminu)</b>
                    <br />
                    Jeżeli pracownikowi przysługuje składnik wynagrodzenia do określonego terminu i termin ten nie upłynął przed rozpoczęciem
                    niezdolności do pracy, podaj datę, do której składnik wynagrodzenia przysługuje oraz kwoty wypłacone pracownikowi za poszczególne
                    miesiące, z których wynagrodzenie jest przyjmowane do ustalenia podstawy wymiaru zasiłku. Wynagrodzenie z tytułu wykonywania
                    umowy zlecenia, umowy agencyjnej lub innej umowy o świadczenie usług, do której zgodnie z Kodeksem cywilnym stosuje się
                    przepisy dotyczące zlecenia albo umowy o dzieło, zawartej po dniu 13 stycznia 2000 r. z pracodawcą, z którym osoba ta pozostaje
                    w stosunku pracy, lub jeżeli w ramach takiej umowy wykonuje pracę na rzecz pracodawcy, traktuje się jako składnik wynagrodzenia
                    przysługujący do określonego terminu. Jeżeli okres, na który umowa jest zawarta, nie upłynął przed rozpoczęciem niezdolności
                    do pracy, podaj okres, na jaki umowa została zawarta oraz przychód osiągnięty z tytułu wykonywania tej umowy, w rozbiciu na
                    poszczególne miesiące, z których wynagrodzenie jest przyjmowane do ustalenia podstawy wymiaru zasiłku.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Uwagi</i></b>
                </font>
                <br /><br />
                <font size="2">
                    Podstawy wymiaru zasiłku nie ustala się na nowo, jeżeli między okresami pobierania zasiłków tego samego rodzaju, jak i innego rodzaju
                    nie było przerwy albo przerwa była krótsza niż 3 miesiące kalendarzowe. Jeżeli w związku z tym w tabelach podałeś wynagrodzenie
                    pracownika z innego okresu niż 12 miesięcy kalendarzowych poprzedzających powstanie niezdolności do pracy, w sekcji Uwagi
                    podaj dodatkowo poprzedni(e) okres(y) pobierania zasiłku lub wynagrodzenia za okres choroby, jeżeli nie zostały wykazane w sekcji
                    Informacje o wypłaconych świadczeniach. W przypadku gdy wynagrodzenie pracownika, które stanowi podstawę wymiaru zasiłku wraz
                    ze składnikami przysługującymi za okres pobierania zasiłku jest na poziomie minimalnego wynagrodzenia za pracę, w sekcji Uwagi
                    podaj miesięczne kwoty składników wynagrodzenia, do których pracownik zachowuje prawo za okres niezdolności do pracy.<br />
                    Jeśli w okresie 12 miesięcy kalendarzowych poprzedzających powstanie niezdolności do pracy albo w miesiącu, w którym
                    powstała niezdolność do pracy, zmienił się wymiar czasu pracy, w sekcji Uwagi podaj poprzedni wymiar czasu pracy, a w tabeli
                    w pkt. 1 podaj wynagrodzenie ustalone dla nowego wymiaru czasu pracy.
                </font>
                <br /><br />
                <font size="3">
                    <b><i>Sekcja: Rachunek bankowy</i></b>
                </font>
                <br />
                <font size="2">
                    Podaj, jeśli pracownik wyraził wolę otrzymywania zasiłku na rachunek bankowy.
                    <br /><br />
                    <b>Ważne!
                    <br />
                    Zaświadczenie płatnika składek Z-3 złóż ponownie, jeśli zmieni się rodzaj pobieranego przez pracownika zasiłku. Nie
                    dotyczy to świadczenia rehabilitacyjnego, jeżeli zaświadczenie płatnika składek złożyłeś do ustalenia prawa do zasiłku
                    chorobowego.<br />
                    Poinformuj terenową jednostkę organizacyjną ZUS o okolicznościach mających wpływ na prawo, wysokość i podstawę
                    wymiaru zasiłku, które uległy zmianie w stosunku do podanych w zaświadczeniu płatnika składek, w szczególności
                    o ustaniu zatrudnienia albo o podjęciu przez pracownika korzystającego z urlopu rodzicielskiego pracy w wymiarze nie
                    wyższym niż połowa etatu.<br />
                    Do wniosku o zasiłek chorobowy, zasiłek opiekuńczy, zasiłek macierzyński, zasiłek w wysokości zasiłku macierzyńskiego,
                    zasiłek wyrównawczy oraz świadczenie rehabilitacyjne dołącz otrzymane od pracownika dokumenty określone
                    w rozporządzeniu Ministra Rodziny, Pracy i Polityki Społecznej z 8 grudnia 2015 r. w sprawie zakresu informacji
                    o okolicznościach mających wpływ na prawo do zasiłków z ubezpieczenia społecznego w razie choroby i macierzyństwa
                    lub ich wysokość oraz dokumentów niezbędnych do przyznania i wypłaty zasiłków.</b>
                </font>
            </p>
            </ea:Section>
		    <ea:SectionMarker ID="SectionMarker8" runat="server" SectionType="GlobalFooter"></ea:SectionMarker>
		</form>
	</body>
</HTML>
